; ------------------------------------------------------------
;   Terminal-Emulation fr E2000-Board (E2000-NET-IO)
;   Oliver Schlenker 02.01.2013
; ------------------------------------------------------------

PVersion$="V1.0"                                      ; Versions-Nummer des Programms
*Command=AllocateMemory(500)                          ; Reservierung fr Datenzeile
FarbeEin=$0000FF : FarbeAus=$FF0000                   ; Farben fr Schalterbeschriftungen, etc.
Font1 = LoadFont(#PB_Any, "Arial", 11, #PB_Font_Bold) ; Fette Schrift fr berschrift laden
Verbindungserhaltungstimer=1000                       ; Timer fr Verbindungserhalt in ms
Verbindungserhaltung$="x"                             ; Irgendwas schicken, selbst wenn Fehler kommt
ZeilenendeCHR$=Chr(13)                                ; Wird bei jeder Zeile angehngt und mitgeschickt

check=ReadFile(1, "E2000-TEmu.ini")                   ; INI-Datei mit IP/DNS und Port 
If check<>0 ; Datei existiert bereits (Einlesen der Eintrge)
  dns$=ReadString(1)
  port$=ReadString(1)
  port=Val(port$)
  httpport$=ReadString(1)
  httpport=Val(httpport$)
  CloseFile(1)
Else        ; Datei existiert noch nicht (Abfrage der Parameter und Ablage in Datei)
  dns$=InputRequester("E2000-TEmu: Meldung", "IP oder DNS (192.168.0.90 / xyz.dyndns.org)?", "192.168.0.90")
  port$=InputRequester("E2000-TEmu: Meldung", "TelNet-Port (64400)?", "64400")
  port=Val(port$)
  httpport$=InputRequester("E2000-TEmu: Meldung", "HTTP-Port (180)?", "180")
  httpport=Val(httpport$)
  CreateFile(1, "E2000-TEmu.ini")
  WriteStringN(1, dns$)
  WriteStringN(1, port$)
  WriteStringN(1, httpport$)
  CloseFile(1)
EndIf

;- Einlesen des Klicksounds
If InitSound()<>0  
  SoundOK=1
  CatchSound(0, ?Klick)  
  DataSection 
    Klick: 
    IncludeBinary "Klick.wav" 
  EndDataSection 
EndIf

;- Gre fr das Fenstergadget festlegen und Windows-/Gadget-Konstanten definieren
#WindowWidth  = 420 : #WindowHeight = 340
Enumeration
  #Window_0
  #Text_0 : #Text_2
  #Button_1 : #Button_2 : #Button_3 : #Button_4 : #Button_5 : #Button_6
  #Editor_1 : #Editor_2 
EndEnumeration

;- Netzwerk initialisieren, falls nicht mglich Fehlermeldung!
If InitNetwork()<>0 : Else : MessageRequester("E2000-NET-IO: Problem", "Das Netzwerk kann nicht initialisiert werden!", 0) : End : EndIf

;- Netzwerkverbindung ffnen, falls nicht mglich Fehlermeldung!
OpenWindow(#Window_0, 10, 10, 250, 90, "E2000-NET-IO: Meldung", #PB_Window_ScreenCentered)
TextGadget(#Text_0, 10, 10, 230, 70, "Verbindungsaufbau zum E2000-NET-IO-Board..."+Chr(13)+Chr(13)+"IP/DNS: "+DNS$+Chr(13)+Chr(13)+"Port: "+Str(Port))
ConnectionIDTY=OpenNetworkConnection(dns$, port) ; Netzwerkverbindung ffnen
If ConnectionIDTY<>0  
  CloseWindow(#Window_0) 
  Else 
  CloseWindow(#Window_0) 
  MessageRequester("E2000-NET-IO: Problem", "Das E2000-NET-IO-Board kann nicht gefunden werden!", 0) 
  End 
EndIf 

;- Definition des Fensters und der Buttons (Feldreihenfolge nicht ndern, da das die Ansprungreihenfolge im Fenster ist)
If OpenWindow(#Window_0, 276, 335, #WindowWidth, #WindowHeight, "E2000-NET-IO-TerminalEmulation "+PVersion$, #PB_Window_MinimizeGadget| #PB_Window_ScreenCentered)
  
  ; Texte
  TextGadget(#Text_2,      10,  10, 400,  20, "Konsole fr direkte Befehle an das E2000-NET-IO-Board", #PB_Text_Center) : SetGadgetFont(#Text_2, FontID(Font1))
  
  ; Editorenfenster
  StringGadget(#Editor_1,  10,  40, 200,  20, "") : GadgetToolTip(#Editor_1, "Konsolenbefehl hier eingeben und anschlieend 'Befehl Senden' anklicken")
  ButtonGadget(#Button_1, 220,  40,  90,  20, "Befehl Senden") : GadgetToolTip(#Button_1, "Konsolenbefehl absenden")
  ButtonGadget(#Button_2, 320,  40,  90,  20, "Befehlsbersicht") : GadgetToolTip(#Button_2, "bersicht der mglichen Konsolen-Befehle")
  EditorGadget(#Editor_2,  10,  70, 400, 200, #PB_Editor_ReadOnly) : GadgetToolTip(#Editor_2, "Hier erscheinen Ihre Konsolenbefehle mit entsprechenden Rckmeldungen des E2000-NET-IO")
  
  ; Knpfe (Standard)
  ButtonGadget(#Button_3,  10, 280, 180,  20, "Elektronik2000-Homepage") : GadgetToolTip(#Button_3, "Zu E2000 (E2000-NET-IO)")
  ButtonGadget(#Button_4, 230, 280, 180,  20, "Oliver-Schlenker-Homepage") : GadgetToolTip(#Button_4, "Zu Oliver Schlenker (E2000-TEmu)")
  ButtonGadget(#Button_6, 230, 310, 180,  20, "E2000-Board via HTTP") : GadgetToolTip(#Button_6, "per HTTP-Zugriff auf das E2000-NET-IO-Board")
  
  ; Knpfe (Spezial)
  ButtonGadget(#Button_5,  10, 310, 180,  20, "Q") : GadgetToolTip(#Button_5, "E2000: Ausfhrung von Q-Befehl")
  
EndIf

AddWindowTimer(#Window_0, 1, Verbindungserhaltungstimer) ; Timer fr Verbindungserhaltung setzen

SetActiveGadget(#Editor_1) ; Cursor Konsolenbefehlsfeld setzen

;- Start einer Schleife fr Ereignisse und Buttonabfragen, bis das Programm beendet wird
Repeat
        
  EventID=WaitWindowEvent(500); max. 500ms auf ein Event im Fenster warten, dann erneute Rckkehr zu diesem WaitWindowEvent ber die Repeat-Schleife
  
  If EventID=#PB_Event_Timer And EventTimer() = 1                           ; Wenn Timerevent ausgelst wurde...
    SendNetworkString(ConnectionIDTY, Verbindungserhaltung$+ZeilenendeCHR$)  ; schicke irgendwas damit der Host antwortet...
    ReceiveNetworkData(ConnectionIDTY, *Command, 100)                        ; und hole die Antwort aus dem Netzwerkpuffer (auch wenn damit nichts gemacht wird!)
  EndIf    

  If EventID = #PB_Event_Gadget
    
    Select EventGadget()
        
      Case #Button_1;- Befehl von Editor senden
        Gosub Klicken
        Gosub Senden
                    
      Case #Button_2;- Hilfe zu den Consolen-Befehlen
        Gosub Klicken
        ClearGadgetItems(#Editor_2)
        SetGadgetColor(#Editor_2, #PB_Gadget_FrontColor, FarbeEin)
        AddGadgetItem(#Editor_2, -1, "Befehle fr das E2000-NET-IO-Board")
        AddGadgetItem(#Editor_2, -1, "")
        AddGadgetItem(#Editor_2, -1, "...")
        AddGadgetItem(#Editor_2, -1, "...")
        ;SetActiveGadget(#Button_1) ; Aktiviere den "Befehl senden" Button
        SetActiveGadget(#Editor_1) ; Cursor Konsolenbefehlsfeld setzen
  
      Case #Button_3
        Gosub Klicken 
        RunProgram("http://www.elektronik2000.de","","",#PB_Program_Open)
          
      Case #Button_4
        Gosub Klicken 
        RunProgram("http://www.oliver-schlenker.de.vu","","",#PB_Program_Open)
        
      Case #Button_5
        Gosub Klicken
        SetGadgetText(#Editor_1, "Q")
        Gosub Senden
        
      Case #Button_6
        Gosub Klicken
        CloseNetworkConnection(ConnectionIDTY)
        RunProgram("http://"+dns$+":"+httpport$,"","",#PB_Program_Open)
        End
           
    EndSelect
  
  EndIf
  
  ;- Fenster immer im Vordergrund der Anwendungen auf dem Desktop halten (auer beim Minimieren natrlich!)
  ;StickyWindow(#Window_0,1)
   
  ResizeWindow(#Window_0, #PB_Ignore, #PB_Ignore, #PB_Ignore, #PB_Ignore) ; verschieben des Fensters ohne neue Pos. (Inhalte auffrischen)
  SmartWindowRefresh(#Window_0,1)                                         ; verhindert eventuelles Flackern
   
Until EventID = #PB_Event_CloseWindow
Gosub Klicken
Delay(100)

;- Schliee Netzwerkverbindung und Ende des Programms
CloseNetworkConnection(ConnectionIDTY)
End

;- ##### Ende des Hauptprogramms #####

;- ##### Unterprogramme #####

Senden: ; Unterprogramm Senden
DisableGadget(#Button_1,1)      ; Sende-Button aussschalten (kein Prellen)
PokeS(*Command, Space(500))     ; Netzwerkbuffer leeren
Text$=GetGadgetText(#Editor_1)  ; Inhalt aus Eingabe-Textfeld bernehmen
If Text$<>""                    ; Wenn Textfeld nicht leer ist..
  SendNetworkString(ConnectionIDTY, Text$+ZeilenendeCHR$)    ; Sende Daten an Board
  ReceiveNetworkData(ConnectionIDTY, *Command, 500)          ; Empfange die Rckmeldung
  ;SetGadgetText(#Editor_1,"")                               ; Lsche Eingabefenster nach jedem Eintrag
  Command$=PeekS(*Command)                                   ; Hole die Rckmeldung aus dem Netzwerkpuffer ab
  ClearGadgetItems(#Editor_2)                                ; Lsche das Rckmeldefenster vor dem neuen Reinschreiben
  SetGadgetColor(#Editor_2, #PB_Gadget_FrontColor, FarbeAus) ; Setze die Farbe fr die Schrift
  AddGadgetItem(#Editor_2, -1, ">"+Text$)                    ; Schreibe in Rckmeldefenster den ursprnglichen Befehl rein
  AddGadgetItem(#Editor_2, -1, Command$)                     ; Schreibe in Rckmeldefenster die Antwort auf den Befehl rein
  Gosub Auswertung                                          ; Werte die Rckmeldung aus
Else                                                        ; ansonsten...
MessageRequester("E2000-NET-IO: Meldung", "Es wurde kein Befehl in die Befehlszeile eingetragen!"+Chr(13)+Chr(13)+"Es wurde keine Datenanfrage abgeschickt!") ; melde das "Problem"
EndIf                   
DisableGadget(#Button_1,0)  ; Sende-Button wieder einschalten
;SetActiveGadget(#Button_1) ; Setze den Cursor auf den "Befehl senden"-Button
SetActiveGadget(#Editor_1)  ; Setze den Cursor auf das Eingabe-Textfeld
Return ; Ende von Unterprogramm Senden

Auswertung: ; Unterprogramm Auswertung
; Gibt's bisher noch nichts auszuwerten
Return ; Ende von Unterprogramm Auswertung

Klicken: ;- Unterprogramm Klick ausfhren
If Soundok=1 
  PlaySound(0)
EndIf
Return ; Ende von Unterprogramm Klick ausfhren

;- ##### Ende der Unterprogramme #####
; IDE Options = PureBasic 5.00 (Windows - x86)
; CursorPosition = 139
; FirstLine = 93
; EnableXP
; UseIcon = favicon.ico
; Executable = E2000-TEmu (E2000-Test).exe
; IncludeVersionInfo
; VersionField0 = 1.0.0.0
; VersionField1 = 1.0.0.0
; VersionField2 = Oliver Schlenker (Privat)
; VersionField3 = E2000-TEMU
; VersionField4 = 1.0
; VersionField5 = 1.0
; VersionField6 = E2000-NET-IO-Board mit Terminalbefehlen ansteuern. (E2000-Firmware 1.2.6)
; VersionField7 = E2000-TEMU
; VersionField8 = E2000-TEMU
; VersionField9 = Copyright by Oliver Schlenker
; VersionField11 = E2000-NET-IO-Board mit Terminalbefehlen ansteuern. (E2000-Firmware 1.2.6)
; VersionField13 = oliver.schlenker@t-online.de
; VersionField14 = http://www.oliver-schlenker.de.vu